//version made 17-4-99 by Alex,so as to be part of the switch-hub project
//the only agregations are IDE, and what IDE does
package kom.itbeankit.nw.ethernet;

import java.awt.*;


import symantec.itools.awt.shape.Line;
import symantec.itools.awt.BorderPanel;
import symantec.itools.awt.shape.HorizontalLine;
import symantec.itools.awt.shape.VerticalLine;
import kom.itbeankit.nw.ethernet.Arrow;
import kom.itbeankit.nw.ethernet.Signal;
import kom.itbeankit.common.vcr.ClkListener;
import kom.itbeankit.common.vcr.ClkEvent;
import kom.itbeankit.common.message.MessageListener;
import kom.itbeankit.common.message.MessageEvent;
import java.util.Hashtable;

public class Host extends java.awt.Container implements EthernetInterface,
                                                        ClkListener
{
    private int csma;
    
    public void setCsma(int c){
        this.csma=c;
    }
    
    public int getCsma(){
        return csma;
    }
    //end of algorithm selection part

	private java.util.Vector dataListeners=new java.util.Vector();
	private java.util.Vector messageListeners=new java.util.Vector();
	private java.util.Vector clkListeners=new java.util.Vector();


    protected HostDialog hostDialog;
	protected int ID = 1;
	//when the host sends something IDE will become ID, so we may allways know when does it sends
	protected int IDE = 0;
	protected int K=0;
	protected boolean overTheBus=true;

	protected int status=HOST_STATUS_IDLE;
	protected MessageEvent msgEvent=null;

	//sender attributes
	//-----------------

    //the CSMA Algorithm as an instance of a class
	//will be set by scenario or through Control Panel by user
    protected AlgorithmInterface algorithm;//= new OnePersistentAlgorithm(this);

	protected DataEvent sendDataEvent=null;

	//the host_ID to which data is been sending or should be sent
	//will be set by scenario or through HostDialog by user
	protected int destinationHost = HOST_ADDRESS_NONE;

	//the size of frames to be sent
	//will be set by scenario or through HostDialog by user
	protected int frameSize = FRAME_SIZE_NORMAL;

	//the remaining size of data to send
	//will be checked and modified by algorithm
	protected int remainingSendDataSize = 0;

	//the sum of all sent data
	//
	protected int sentDataSize = 0;

	//the countdown timer's time
    protected int countdownTime = 0;

    //shows if there is signal on the bus
    //can be SIGNAL_STATUS_ON or _OFF
	protected int carrierSense = SIGNAL_STATUS_OFF;

	//shows if collision is detected
    //can be SIGNAL_STATUS_ON ,_OFF or _ALARM
	protected int collisionDetect = SIGNAL_STATUS_OFF;

	//defines number of tries for sending
	//after which the frame should be thrown away
	protected int maxCollisionCount = MAX_COLLISION_COUNT;

	//the current number of tries for sending
	protected int collisionCount=0;

	//if the sending shoul be repeated automatically after a random time
	protected boolean autoRepeat=false;

	//if padding in case of short frames should be used
	protected boolean usePadField=false;

	//receiver attributes
	//-------------------
	protected DataEvent oldReceiveDataEvent=null;
	protected DataEvent newReceiveDataEvent=null;

	//the host_ID from which the host is at the moment receiving
	protected int sourceHost=0;

	//the size of a not completely received frame
	protected int bufferedReceivedDataSize=0;

	//the total size of received data
	//is the sum of all received frame sizes
	protected int receivedDataSize=0;

	protected int remainingReceiveDataSize = 0;


	public Host()
	{
		//{{INIT_CONTROLS
		setLayout(new BorderLayout(0,0));
		setSize(80,74);
		panel = new java.awt.Panel();
		panel.setLayout(null);
		panel.setBounds(0,0,104,74);
		add("Center", panel);
		dTopLeft = new symantec.itools.awt.shape.Line();
		try {
			dTopLeft.setPositiveSlope(true);
		}
		catch(java.beans.PropertyVetoException e) { }
		dTopLeft.setBounds(0,38,20,20);
		panel.add(dTopLeft);
		dTopRight = new symantec.itools.awt.shape.Line();
		try {
			dTopRight.setPositiveSlope(true);
		}
		catch(java.beans.PropertyVetoException e) { }
		dTopRight.setBounds(59,38,20,20);
		panel.add(dTopRight);
		mTopLeft = new symantec.itools.awt.shape.Line();
		try {
			mTopLeft.setPositiveSlope(true);
		}
		catch(java.beans.PropertyVetoException e) { }
		mTopLeft.setBounds(12,0,10,10);
		panel.add(mTopLeft);
		mTopRight = new symantec.itools.awt.shape.Line();
		try {
			mTopRight.setPositiveSlope(true);
		}
		catch(java.beans.PropertyVetoException e) { }
		mTopRight.setBounds(55,0,10,10);
		panel.add(mTopRight);
		dRightBottom = new symantec.itools.awt.shape.Line();
		try {
			dRightBottom.setPositiveSlope(true);
		}
		catch(java.beans.PropertyVetoException e) { }
		dRightBottom.setBounds(60,53,20,20);
		panel.add(dRightBottom);
		mRightBottom = new symantec.itools.awt.shape.Line();
		try {
			mRightBottom.setPositiveSlope(true);
		}
		catch(java.beans.PropertyVetoException e) { }
		mRightBottom.setBounds(55,43,10,10);
		panel.add(mRightBottom);
		mTopBack = new symantec.itools.awt.shape.HorizontalLine();
		mTopBack.setBounds(22,0,44,1);
		panel.add(mTopBack);
		mRightBack = new symantec.itools.awt.shape.VerticalLine();
		mRightBack.setBounds(65,0,1,44);
		panel.add(mRightBack);
		dTopBack = new symantec.itools.awt.shape.HorizontalLine();
		dTopBack.setBounds(66,38,14,1);
		panel.add(dTopBack);
		dRightBack = new symantec.itools.awt.shape.VerticalLine();
		dRightBack.setBounds(79,38,1,16);
		panel.add(dRightBack);
		dFrontPanel = new symantec.itools.awt.BorderPanel();
		try {
			dFrontPanel.setIPadBottom(0);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			dFrontPanel.setIPadSides(1);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			dFrontPanel.setPaddingRight(0);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			dFrontPanel.setPaddingBottom(0);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			dFrontPanel.setPaddingTop(0);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			dFrontPanel.setIPadTop(1);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			dFrontPanel.setPaddingLeft(0);
		}
		catch(java.beans.PropertyVetoException e) { }
		dFrontPanel.setLayout(new GridLayout(1,1,0,0));
		dFrontPanel.setBounds(0,58,60,16);
		dFrontPanel.setBackground(new Color(-1644826));
		panel.add(dFrontPanel);
		dFrontPanel.setCursor(new Cursor(Cursor.HAND_CURSOR));
		hostNumberLabel = new java.awt.Label("1",Label.CENTER);
		hostNumberLabel.setBounds(0,0,19,14);
		dFrontPanel.add(hostNumberLabel);
		csSignal = new kom.itbeankit.nw.ethernet.Signal();
		csSignal.setText("CS");
		csSignal.setAlignment(0);
		csSignal.setBounds(19,0,19,14);
		csSignal.setFont(new Font("Dialog", Font.BOLD, 12));
		csSignal.setForeground(new Color(8421504));
		dFrontPanel.add(csSignal);
		cdSignal = new kom.itbeankit.nw.ethernet.Signal();
		cdSignal.setText("CD");
		cdSignal.setAlignment(0);
		cdSignal.setBounds(38,0,19,14);
		cdSignal.setFont(new Font("Dialog", Font.BOLD, 12));
		cdSignal.setForeground(new Color(8421504));
		dFrontPanel.add(cdSignal);
		mFrontPanel = new symantec.itools.awt.BorderPanel();
		try {
			mFrontPanel.setIPadBottom(0);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			mFrontPanel.setIPadSides(1);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			mFrontPanel.setPaddingRight(0);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			mFrontPanel.setPaddingBottom(0);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			mFrontPanel.setPaddingTop(0);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			mFrontPanel.setIPadTop(1);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			mFrontPanel.setPaddingLeft(0);
		}
		catch(java.beans.PropertyVetoException e) { }
		mFrontPanel.setLayout(new BorderLayout(0,0));
		mFrontPanel.setBounds(12,10,44,44);
		mFrontPanel.setBackground(new Color(16777215));
		panel.add(mFrontPanel);
		arrow = new kom.itbeankit.nw.ethernet.Arrow();
		arrow.setLayout(new BorderLayout(0,0));
		arrow.setBounds(0,0,41,42);
		mFrontPanel.add("Center", arrow);
		//}}
		dFrontPanel.setBackground(new Color(HOST_COLOR_IDLE));
		//mFrontPanel.setBackground(new Color(HOST_COLOR_IDLE));
		csma = 1;// 1-persistent
		arrow.turnOff();
		setSize(80,74);
		//{{REGISTER_LISTENERS
		SymMouse aSymMouse = new SymMouse();
		panel.addMouseListener(aSymMouse);
		arrow.addMouseListener(aSymMouse);
		csSignal.addMouseListener(aSymMouse);
		cdSignal.addMouseListener(aSymMouse);
		hostNumberLabel.addMouseListener(aSymMouse);
		dFrontPanel.addMouseListener(aSymMouse);
		mFrontPanel.addMouseListener(aSymMouse);
		//}}
	}

	//{{DECLARE_CONTROLS
	java.awt.Panel panel;
	symantec.itools.awt.shape.Line dTopLeft;
	symantec.itools.awt.shape.Line dTopRight;
	symantec.itools.awt.shape.Line mTopLeft;
	symantec.itools.awt.shape.Line mTopRight;
	symantec.itools.awt.shape.Line dRightBottom;
	symantec.itools.awt.shape.Line mRightBottom;
	symantec.itools.awt.shape.HorizontalLine mTopBack;
	symantec.itools.awt.shape.VerticalLine mRightBack;
	symantec.itools.awt.shape.HorizontalLine dTopBack;
	symantec.itools.awt.shape.VerticalLine dRightBack;
	symantec.itools.awt.BorderPanel dFrontPanel;
	java.awt.Label hostNumberLabel;
	kom.itbeankit.nw.ethernet.Signal csSignal;
	kom.itbeankit.nw.ethernet.Signal cdSignal;
	symantec.itools.awt.BorderPanel mFrontPanel;
	kom.itbeankit.nw.ethernet.Arrow arrow;
	//}}

    public void fill(Color c){
        Graphics g=panel.getGraphics();
        g.setColor(c);
        //fill monitorTop
        int[] mTopX={23,64,55,13};
        int[] mTopY={1,1,10,10};
        g.fillPolygon(mTopX,mTopY,4);
        //fill monitorSide
        int[] mSideX={56,65,65,56};
        int[] mSideY={11,2,43,52};
        g.fillPolygon(mSideX,mSideY,4);
        //fill desktopTop
        int[] dTopX={12,12,56,66,66,78,59,1};
        int[] dTopY={48,54,54,44,39,39,58,58};
        g.fillPolygon(dTopX,dTopY,8);
        //fill desktopSide
        int[] dSideX={60,79,79,60};
        int[] dSideY={58,39,53,72};
        g.fillPolygon(dSideX,dSideY,4);
    }

    public void reset(){
        
        status = HOST_STATUS_IDLE;
        
        oldReceiveDataEvent=null;
        newReceiveDataEvent=null;
        sendDataEvent=null;
        
        carrierSense = SIGNAL_STATUS_OFF;
        collisionDetect = SIGNAL_STATUS_OFF;
        
        setDestinationHost(HOST_ADDRESS_NONE);
        setFrameSize(FRAME_SIZE_NORMAL);
        setAutoRepeat(false);
        
        countdownTime = 0;
        collisionCount = 0;
        
        sentDataSize = 0;
        remainingSendDataSize = 0;
        
        bufferedReceivedDataSize = 0;
        receivedDataSize = 0;
        remainingReceiveDataSize = 0;
        
    }
    
    public void resetDataSize(){
        sentDataSize = 0;
        receivedDataSize = 0;
    }
    
    public synchronized void addClkListener(ClkListener lis)
    {
        clkListeners.addElement(lis);
    }

    public synchronized void removeClkListener(ClkListener lis)
    {
        clkListeners.removeElement(lis);
    }

    public synchronized void addDataListener(DataListener lis)
    {
        dataListeners.addElement(lis);
    }

    public synchronized void removeDataListener(DataListener lis)
    {
        dataListeners.removeElement(lis);
    }

    public synchronized void addMessageListener(MessageListener lis)
    {
        messageListeners.addElement(lis);
    }

    public synchronized void removeMessageListener(MessageListener lis)
    {
        messageListeners.removeElement(lis);
    }




    public void dataFromTop(DataEvent e)
    {
        newReceiveDataEvent = e;
    }

    public void dataFromBottom(DataEvent e)
    {
        newReceiveDataEvent = e;
    }

    //Clock Functions
    public void clkReceived(ClkEvent e){
        if(algorithm==null)
            setAlgorithm(csma);
        
        if(e.isRisingEdge()){
            algorithm.processStatus(status);
        }
        else{
            oldReceiveDataEvent = newReceiveDataEvent;
            newReceiveDataEvent = null;
        }
    }
    //Clock Functions End


    public Dimension getPreferredSize(){
        return new Dimension(80,74);
    }

    public void paint(Graphics g){
        setSize(getPreferredSize());
        super.paint(g);
    }

    //this method will be called from algorithm
    //as a reult of processStatus
    //host sets its status, fires the needed event
    //and shows its status in GUI
    public void onStatus(int hostStatus){
	    
	    //set the new status
	    this.status = hostStatus;
	    //fire event
		if(sendDataEvent != null){
		    if(overTheBus)
		        dataToBottom(sendDataEvent);
		    else
		        dataToTop(sendDataEvent);
		}
		
		if(msgEvent != null){
            fireMessageEvent(msgEvent);
            msgEvent = null;
		}

		//show signals
		csSignal.setStatus(carrierSense);
		cdSignal.setStatus(collisionDetect);


	    //show arrow
	    switch(status){
	        case HOST_STATUS_IDLE :
	            //it doesnt send so
	            IDE=0; K=0;
	            //arrow off
	            arrow.turnOff();
	        break;
		    case HOST_STATUS_CARRIER_SENSE :
		        //arrow thin
                setArrowThin();
                arrow.arrowTimerLabel.setText("");
                arrow.arrowTimerLabel.setVisible(false);
	        break;
            case HOST_STATUS_COUNTDOWN :
                //arrow countdown
                setArrowThin();
                arrow.setNumber(countdownTime);// /(((int)RANDOM_TIME_SCALE+1)/10));
	        break;
	        case HOST_STATUS_RECEIVING_DATA :
    	        //arrow thick data to inside
                setArrowReceive(DATA_COLOR_DATA);
	        break;
	        case HOST_STATUS_RECEIVING_PAD :
	            //arrow thick pad to inside
                setArrowReceive(DATA_COLOR_PADDING);
	        break;
	        case HOST_STATUS_SENDING_DATA :
	            // it sends so
	            IDE=ID;K ++;
	            //arrow thick data to outside
                setArrowSend(DATA_COLOR_DATA);
	        break;
	        case HOST_STATUS_SENDING_PAD :
    	        //arrow thick pad to outside
                setArrowSend(DATA_COLOR_PADDING);
	        break;
	        case HOST_STATUS_SENDING_NOISE :
    	        //arrow thick noise to outside
                setArrowSend(DATA_COLOR_COLLISION);
	        break;
	        default:
	    }
		//set backgroung active or passive
		int background = HOST_COLOR_PASSIVE;
	    if(status > HOST_STATUS_ACTIVE){
	        background = HOST_COLOR_ACTIVE;
	    }
	    fill(new Color(background));
    }

    void setArrowThin(){
        if(overTheBus){
            arrow.turnCountdownDown();
        }
        else{
            arrow.turnCountdownUp();
        }
    }

    void setArrowReceive(int colorCode){
        if(overTheBus)
            arrow.turnThickUp();
        else
            arrow.turnThickDown();
        arrow.fill(new Color(colorCode));
    }

    void setArrowSend(int colorCode){
        if(overTheBus)
            arrow.turnThickDown();
        else
            arrow.turnThickUp();
        arrow.fill(new Color(colorCode));
    }

	public void setStatus(int hostStatus)
	{
		this.status = hostStatus;
	}

	public int getStatus()
	{
		return this.status;
	}

	public void setID(int ID)
	{
	        this.ID = ID;
			hostNumberLabel.setText(new Integer(ID).toString());
	}

	public int getID()
	{
		return ID;
	}
    public int getIDE()
	{   
	    if (K==0)
		return IDE;
		else if (K==1) return IDE;
		else return 0;
	}
	public void setIDE(int IDE)
	{
	        this.IDE = IDE;
			
	}
	public void setDestinationHost(int destinationHost)
	{
			this.destinationHost = destinationHost;
			if(hostDialog!=null)
			    hostDialog.setDestinationHost(destinationHost);
	}

	public int getDestinationHost()
	{
		return this.destinationHost;
	}

	public void setFrameSize(int frameSize)
	{
			this.frameSize = frameSize;
			if(hostDialog!=null)
			    hostDialog.setFrameSize(frameSize);
	}

	public int getFrameSize()
	{
		return this.frameSize;
	}

	public void setAutoRepeat(boolean autoRepeat)
	{
			this.autoRepeat = autoRepeat;
			if(hostDialog!=null)
			    hostDialog.setAutoRepeat(autoRepeat);
	}
	public boolean isAutoRepeat()
	{
		return this.autoRepeat;
	}

	public void setUsePadField(boolean usePadField)
	{
			this.usePadField = usePadField;
	}

	public boolean isUsePadField()
	{
		return this.usePadField;
	}


	public void setCountdownTime(int countdownTime)
	{
			this.countdownTime = countdownTime;
	}

	public int getCountdownTime()
	{
		return this.countdownTime;
	}

	public int getReceivedDataSize()
	{
		return this.receivedDataSize;
	}

	public void setReceivedDataSize(int receivedDataSize)
	{
		this.receivedDataSize = receivedDataSize;
	}

	public int getSentDataSize()
	{
		return this.sentDataSize;
	}

	public void setSentDataSize(int sentDataSize)
	{
		this.sentDataSize = sentDataSize;
	}

	public void setOverTheBus(boolean overTheBus)
	{
			this.overTheBus = overTheBus;
	}

	public boolean isOverTheBus()
	{
		return this.overTheBus;
	}

    public void setAlgorithm(String algorithmName){
        if(algorithm != null)
            algorithm.cleanup();
        try{
            algorithm = (AlgorithmInterface)Class.forName(algorithmName).newInstance();
        }catch(Exception e){}//Error Dialog: algorithm class not found
        algorithm.setHost(this);
    }

    
    public void setAlgorithm(int algorithmNumber){
        if(algorithm != null)
            algorithm.cleanup();
        String algorithmName;
        if(algorithmNumber==1)
            algorithmName = "kom.itbeankit.nw.ethernet.OnePersistentAlgorithm";
        else
            algorithmName = "kom.itbeankit.nw.ethernet.NonPersistentAlgorithm";
        
        try{
            algorithm = (AlgorithmInterface)Class.forName(algorithmName).newInstance();
        }catch(Exception e){}//Error Dialog: algorithm class not found
        algorithm.setHost(this);
    }


	//public boolean mouseDown(java.awt.Event a, int b, int c)
	//{
		// todo. Add overriding code here.
	//}

	static public void main(String args[])
	{
		class DriverFrame extends java.awt.Frame {
			public DriverFrame() {
				addWindowListener(new java.awt.event.WindowAdapter() {
					public void windowClosing(java.awt.event.WindowEvent event)
					{
						dispose();	  // free the system resources
						System.exit(0); // close the application
					}
				});
				this.setLayout(new java.awt.BorderLayout());
				this.setSize(300,300);
				this.add(new Host());
			}
		}

		new DriverFrame().show();
	}


	class SymMouse extends java.awt.event.MouseAdapter
	{
		public void mouseClicked(java.awt.event.MouseEvent event)
		{
			host_mouseClicked(event);
		}
	}

    //at mouse click a HostDialog will be shown
    //or if already open, it will get focus
    void host_mouseClicked(java.awt.event.MouseEvent event)
	{
	    if(isEnabled()){
    	    //find the frame for Dialog
    	    Component c = this;
    		while(!(c instanceof java.awt.Frame)){
    		    c = c.getParent();
    		}
    		//open a new Dialog if there none active
    		if(hostDialog != null)
    		    hostDialog.toFront();
    		else{
        		hostDialog = new HostDialog((Frame)c,this);
        		//hostDialog.setLocation(event.getX(),event.getY());
        		hostDialog.setVisible(true);
    		}
    	}
	}

	void dataToBottom(int dataType, int dataSize, int destination, boolean startBit, boolean stopBit)
	{
        for(int i=0; i<dataListeners.size();i++){
            DataListener dl = (DataListener)dataListeners.elementAt(i);
            dl.dataToBottom(new DataEvent(this,dataSize,dataType,ID,destination,startBit,stopBit));
        }
	}

	void dataToTop(int dataType, int dataSize, int destination, boolean startBit, boolean stopBit)
	{
        for(int i=0; i<dataListeners.size();i++){
            DataListener dl = (DataListener)dataListeners.elementAt(i);
            dl.dataToTop(new DataEvent(this,dataSize,dataType,ID,destination,startBit,stopBit));
        }
	}

	void dataToBottom(DataEvent event)
	{
        for(int i=0; i<dataListeners.size();i++){
            DataListener dl = (DataListener)dataListeners.elementAt(i);
            dl.dataToBottom(event);
        }
	}

	void dataToTop(DataEvent event)
	{
        for(int i=0; i<dataListeners.size();i++){
            DataListener dl = (DataListener)dataListeners.elementAt(i);
            dl.dataToTop(event);
        }
	}
	//to be called by closing event
	public void cleanup(){

	    if(hostDialog!=null){
            //set references to null and close the dialog
            hostDialog.host = null;
            hostDialog = null;
            hostDialog.dispose();
	    }
	}
	
	void fireMessageEvent(MessageEvent me){
        for(int i=0; i<messageListeners.size();i++){
            MessageListener ml = (MessageListener)messageListeners.elementAt(i);
            ml.deliverMessage(me);
        }
	}
	
	public void setEnabled(boolean b){
	    super.setEnabled(b);
	    dFrontPanel.setEnabled(b);
	    if(b)
		    dFrontPanel.setCursor(new Cursor(Cursor.HAND_CURSOR));
	    else
		    dFrontPanel.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
	}
	
}